	page	,132
	title	swab -- block copy, swapping odd/even bytes
;***
;swab.asm - block copy, while swapping even/odd bytes
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the routine swab() which swaps the odd/even
;	bytes of words during a block copy.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
.list				;Includes under a .xlist/.list pair

assumes cs,CODE

	page

sBegin	CODE

page
;***
;_swab(srcptr, dstptr, nbytes) - swap ODD/EVEN bytes during word move
;
;Purpose:
;	This routine copys a block of words and swaps the odd and even
;	bytes.	nbytes must be > 0, otherwise nothing is copied.  If
;	nbytes is odd, then only (nbytes-1) bytes are copied.
;
;Entry:
;	srcptr = pointer to the source block
;	dstptr = pointer to the destination block
;	nbytes = number of bytes to swap
;
;Exit:
;	None.
;
;Uses:
;	AX, BX, CX, DX.
;
;Exceptions:
;
;*******************************************************************************

cProc	_swab,<PUBLIC>,<>
	parmDP	srcptr
	parmDP	dstptr
	parmW	nbytes
cBegin
	mov	cx,nbytes
	sar	cx,1		; Convert the byte count to a word count
	jle	swab9		; do nothing if count <= 0

	push	si		; preserve SI and DI registers
	push	di

if sizeD
	push	ds		; Save DS
	lds	si,srcptr
	les	di,dstptr
else
	mov	si,srcptr
	mov	di,dstptr
	push	ds
	pop	es
endif
	cld

swab1:	lodsw			; Get next 2 bytes
	xchg	ah,al		; Swap those bytes
	stosw			; Store the swapped bytes
	loop	swab1

if sizeD
	pop	ds		; Restore DS
endif
	pop	di		; restore SI and DI registers
	pop	si

swab9:

cEnd

sEnd	CODE

	end
