/***
*tolower.c - convert character to lower case
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   Defines function versions of _tolower() and tolower().
*
*******************************************************************************/

#include <ctype.h>
#include <stddef.h>

/* remove macro defintions of _tolower() and tolower()
 */
#undef  _tolower
#undef  tolower

/* define function-like macro equivalent to _tolower()
 */
#define mklower(c)  ( (c)-'A'+'a' )

/***
*int _tolower(c) - convert character to lower case
*
*Purpose:
*   _tolower() is simply a function version of the macro of the same name.
*
*Entry:
*   c - int value of character to be converted
*
*Exit:
*   returns int value of lower case representation of c
*
*Exceptions:
*
*******************************************************************************/


int  _tolower(c)
int c;
{
    return(mklower(c));
}


/***
*int tolower(c) - convert character to lower case
*
*Purpose:
*   tolower() is simply a function version of the macro of the same name.
*
*Entry:
*   c - int value of character to be converted
*
*Exit:
*   if c is an upper case letter, returns int value of lower case
*   representation of c. otherwise, it returns c.
*
*Exceptions:
*
*******************************************************************************/


int  tolower(c)
int c;
{
    return(isupper(c) ? mklower(c) : c);
}
