/***
*toupper.c - convert character to uppercase
*
*   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   Defines function versions of _toupper() and toupper().
*
*******************************************************************************/

#include <ctype.h>
#include <stddef.h>

/* remove macro definitions of _toupper() and toupper()
 */
#undef  _toupper
#undef  toupper

/* define function-like macro equivalent to _toupper()
 */
#define mkupper(c)  ( (c)-'a'+'A' )


/***
*_toupper(c) - convert character to upper case
*
*Purpose:
*   _toupper() is simply a function version of the macro of the same name.
*
*Entry:
*   c - int value of character to be converted
*
*Exit:
*   returns int value of uppercase representation of c
*
*Exceptions:
*
*******************************************************************************/

int  _toupper(c)
int c;
{
    return(mkupper(c));
}


/***
*toupper(c) - convert character to upper case
*
*Purpose:
*   toupper() is simply a functional version of the macro of the same name.
*
*Entry:
*   c - int value of character to be converted
*
*Exit:
*   if c is a lower case letter, returns int value of uppercase
*   representation of c. otherwise, it returns c.
*
*Exceptions:
*
*******************************************************************************/

int  toupper(c)
int c;
{
    return(islower(c) ? mkupper(c) : c);
}
