/***
*wcstombs.c - Convert wide char string to multibyte char string.
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Convert a wide char string into the equivalent multibyte char string.
*
*******************************************************************************/

#include <stdlib.h>
#include <limits.h>
#include <internal.h>


/***
*size_t wcstombs() - Convert wcs to mbcs
*
*Purpose:
*   Convert a wide char string into the equivalent multibyte char string,
*   according to the LC_CTYPE category of the current locale.
*   [ANSI].
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*Entry:
*   char *s            = pointer to destination multibyte char string
*   const wchar_t *pwc = pointer to source wide character string
*   size_t           n = maximum number of bytes to store in s
*
*Exit:
*   If s != NULL, returns    (size_t)-1 (if character cannot be converted)
*                or number of bytes comprising the converted
*                mb string, not including any terminating NUL.
*
*Exceptions:
*   Returns (size_t)-1 if pwcs is NULL or a character cannot be converted
*
*******************************************************************************/

#ifdef  MODELINDEP
size_t __far __cdecl  _fwcstombs
    (
    char __far *s,
    const wchar_t __far *pwcs,
#else                           /* MODELINDEP */
size_t _cdecl  wcstombs
    (
    char *s,
    const wchar_t *pwcs,
#endif                          /* MODELINDEP */
    size_t n
    )

{
int i;
int retval = 0;
size_t count = 0;
_WINSTATIC char buffer[MB_LEN_MAX];

    if (!pwcs)
        return (size_t)-1;  /* not required, but smart */

    while (count<n)
        {
#ifdef  MODELINDEP
        retval=_fwctomb(buffer, *(pwcs++));
#else   /* MODELINDEP */
        retval=  wctomb(buffer, *(pwcs++));
#endif  /* MODELINDEP */

        if (retval <= 0)
        {
        if (retval < 0)
            return (size_t)-1;  /* return error */
        break;          /* NUL encountered */
        }

        if (count+retval > n)
        return count;       /* ignore if not enough room */

        for (i=0; i<retval;)    /* store character */
        {
        if((s[count] = buffer[i++])=='\0')
            return count;  /* done if NUL */
        else
            count++;
        }
        }

    if (count<n)
        s[count] = '\0';  /* NUL terminate, if room */

    return count;
}
