/***
*wctomb.c - Convert multibyte char to wide char.
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Convert a wide character into the equivalent multibyte character.
*
*******************************************************************************/

#include <stdlib.h>
#include <ctype.h>


/***
*int wctomb() - Convert wc to mbc
*
*Purpose:
*   Convert a wide character into the equivalent multi-byte character,
*   according to the LC_CTYPE category of the current locale.
*   [ANSI].
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*Entry:
*   char *s          = pointer to multibyte character
*   wchar_t wchar        = source wide character
*
*Exit:
*   If s = NULL, returns 0, indicating we only use state-independent
*   character encodings.
*   If s != NULL, returns:   0 (if *s = null char)
*               -1 (if error) or number of bytes comprising
*               converted mbc
*
*Exceptions:
*
*******************************************************************************/

#ifdef  MODELINDEP
int __far __cdecl  _fwctomb
    (
    char __far *s,
#else                           /* MODELINDEP */
int _cdecl  wctomb
    (
    char *s,
#endif                          /* MODELINDEP */
    wchar_t wchar
    )

{
    //  Hard coded for "C" locale:  replace with unicode

    if (!s)
        return 0;

    if (wchar>255)  /* validate high byte */
        return -1;

    *s = (char) wchar;
    return sizeof(char);
}
