	page	,132
	title	xtoa - convert integers/longs to ASCII string
;***
;xtoa.asm - convert integers/longs to ASCII string
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	The module has code to convert integers/longs to ASCII strings.  See
;	the files ITOA.ASM, LTOA.ASM, ULTOA.ASM for entry points to
;	these routines.
;
;*******************************************************************************

include version.inc
.xlist
include cmacros.inc
.list

sBegin	code
assumes cs,code
assumes ds,data


cProc	_cltoasub,<PUBLIC>,<di,si>

	parmd	lval
	parmdp	lbuf
	parmw	lradix

cBegin nogen
	mov	cx,lradix
	mov	ax,word ptr (lval)
	mov	dx,word ptr (lval+2)
if	sizeD
	push	ds
	lds	di,lbuf
else
	mov	di,lbuf
endif

;	ds:di = buffer
;	dx:ax = value
;	cx = radix
;	bl = 1 if signed, 0 if unsigned

	public	__cxtoa

__cxtoa:
	push	di			; save start of buffer
	push	ds
	pop	es			; ds = es = segment of buffer
	cld
	xchg	bx,ax			; dx:bx = number , ax = signed
	or	al,al
	jz	uxtoa			; unsigned conversion

	cmp	cx,10			; check for radix = 10
	jne	uxtoa			;   no - treat as unsigned

	or	dx,dx			; test for negative number
	jns	uxtoa

	mov	al,'-'
	stosb				; stuff out -
	neg	bx			; negate dx:bx
	adc	dx,0
	neg	dx

uxtoa:
	mov	si,di			; save start of number

divdown:
	xchg	ax,dx			; divide hi
	xor	dx,dx
	or	ax,ax
	jz	nohigh			; save a divide
	div	cx			; dx = rem, ax = hi div

nohigh:
	xchg	ax,bx			; ax = lo, bx = hi div
	div	cx			; dx = rem, bx:ax = div
	xchg	ax,dx			; ax = rem, bx:dx = div
	xchg	dx,bx			; ax = rem, dx:bx = div (tight!!!!)
	add	al,'0'
	cmp	al,'9'
	jbe	isadig			; is a digit already
	add	al,'a'-'0'-10		; convert to letter

isadig:
	stosb
	mov	ax,dx
	or	ax,bx
	jnz	divdown 		; crack out next digit

;	reverse digits

	mov	[di],al 		; stuff string terminator

revloop:
	dec	di			; point back to last char
	lodsb				; exchange bytes
	xchg	[di],al
	mov	[si-1],al
; The following is equivalent to "cmp si,(di-1)"
; but avoids segment wrap in case DI == 0
	lea	ax,[si+1]
	cmp	ax,di			; are we halfway?
	jb	revloop 		;   no

if	sizeD
	mov	dx,ds			; buffer segment
endif
	pop	ax			; buffer offset
if	sizeD
	pop	ds			; restore DGROUP
endif

cEnd

sEnd	code

	end
