	page	,132
	title	ctype - Function versions of ctype macros
;***
;_ctype.asm - function versions of ctype macros
;
;	Copyright (c) 1988-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This files provides function versions of the character
;	classification and conversion macros in ctype.h.
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
.list


; Define masks

_UPPER	 equ	01h
_LOWER	 equ	02h
_DIGIT	 equ	04h
_SPACE	 equ	08h
_PUNCT	 equ	10h
_CONTROL equ	20h
_BLANK	 equ	40h
_HEX	 equ	80h


sBegin	data
	assumes	ds,data
	extrn	__ctype_:byte
sEnd


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; ctype - Function versions of ctype macros
;
;Purpose:
;
;Entry:
;	int = character to be tested
;Exit:
;	ax = non-zero = character is of the requested type
;	   =        0 = character is NOT of the requested type
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

	public	_isalpha
_isalpha:
	mov	ax,(_UPPER OR _LOWER)
	jmp	short ctype

	public	_isupper
_isupper:
	mov	ax,_UPPER
	jmp	short ctype

	public	_islower
_islower:
	mov	ax,_LOWER
	jmp	short ctype

	public	_isdigit
_isdigit:
	mov	ax,_DIGIT
	jmp	short ctype

	public	_isxdigit
_isxdigit:
	mov	ax,_HEX
	jmp	short ctype

	public	_isspace
_isspace:
	mov	ax,_SPACE
	jmp	short ctype

	public	_ispunct
_ispunct:
	mov	ax,_PUNCT
	jmp	short ctype

	public	_isalnum
_isalnum:
	mov	ax,(_UPPER OR _LOWER OR _DIGIT)
	jmp	short ctype

	public	_isprint
_isprint:
	mov	ax,(_BLANK OR _PUNCT OR _UPPER OR _LOWER OR _DIGIT)
	jmp	short ctype

	public	_isgraph
_isgraph:
	mov	ax,(_PUNCT OR _UPPER OR _LOWER OR _DIGIT)
	jmp	short ctype

	public	_iscntrl
_iscntrl:
	mov	ax,_CONTROL
	;jmp	 short ctype


; Common code
; al = character mask

cProc	ctype,<LOCAL>,<>

	parmW	char

cBegin

ifdef	_LOAD_DGROUP
	push	ds
	mov	bx,DGROUP
	mov	ds,bx
endif	;_LOAD_DGROUP

	mov	bx,[char]		; get input character

	and	al,[bx+__ctype_+1]	; 'and' with entry in _ctype[]

ifdef	_LOAD_DGROUP
	pop	ds
endif	;_LOAD_DGROUP

cEnd	<nolocals>

sEnd

	end
