	page	,132
	title	ctype - Function versions of ctype macros
;***
;_ctypex.asm - function versions for extended ctype macros
;
;	Copyright (c) 1989-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This files provides function versions of the isascii(), toascii(),
;	iscsym() and iscsymf() macros.
;
;*******************************************************************************

.xlist
include version.inc
include cmacros.inc
.list


externP isalpha
externP isalnum


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
; int __isascii(chr) - function version of __isascii() macro
;
;Purpose:
;	Tests whether or not chr is part of the ASCII character set (i.e.,
;	if 0 <= chr <= 0x7f). isascii() is normally a macro, but it is also
;	provided as a true function for consistency with ANSI (though it
;	is not required by ANSI).
;
;Entry:
;	int chr - character to be tested
;Exit:
;	returns non-zero if and only if chr is a legal ASCII character
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	__isascii,<PUBLIC>,<>

	parmW	chr

cBegin
	xor	ax,ax
	cmp	byte ptr [chr],80h
	jae	isascii_done
	inc	ax
isascii_done:
cEnd	<nolocals>


page
;***
; int __toascii(chr) - function version of __toascii() macro
;
;Purpose:
;	Converts chr to a legal ASCII character by masking off all but the
;	lower 7 bits. toascii() is normally a macro, but it is also provided
;	as a true function for consistency with ANSI (though it is not
;	required by ANSI).
;
;Entry:
;	int chr - character to be converted
;
;Exit:
;	returns chr with all but the lower 7 bits masked off
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	__toascii,<PUBLIC>,<>

	parmW	chr

cBegin
	mov	ax,chr
	and	ax,7fh
cEnd	<nolocals>


;***
; int __iscsym(chr), __iscymf(chr) - Function versions of __iscsym() and
;	__iscsymf() macros
;
;Purpose:
;	iscsym(chr) tests if chr is legal as a character in a C identifier.
;	iscsymf(chr) tests if chr is legal as the first character in a C
;	identifier. These are normally macros, but are also provided as true
;	functions for consistency with ANSI (though it is not required).
;
;Entry:
;	int chr - character to be tested
;Exit:
;	returns nonzero if and only if the given character (chr) satisfies
;	the condition
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	__iscsym,<PUBLIC>,<>

	parmW	chr

cBegin
	push	chr
	callcrt isalnum
	jmp	short csym_common
cEnd	<nogen>


cProc	__iscsymf,<PUBLIC>,<>

	parmW	chr

cBegin
	push	chr
	callcrt isalpha

csym_common::
	pop	bx
	or	ax,ax
	jnz	csym_done
	cmp	chr,'_'
	jne	csym_done
	inc	ax
csym_done:
cEnd	<nolocals>

sEnd
	end
