	page	,132
	title	allocmem - contains the _dos_allocmem() function
;***
;allocmem.asm - _dos_allocmem() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_allocmem() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list

	extrn	__dosreturn:near

sBegin	code

	assumes cs,code

page
;***
;unsigned _dos_allocmem(size, p_segment) - allocate memory directly from DOS
;
;Purpose:
;	The function "_dos_allocmem" allows the user to allocate
;	memory directly from the DOS, via INT 21H function 48H.
;	If the allocation fails, the maximum number of contiguous
;	free paragraphs is returned instead of a segment address
;
;Entry:
;	unsigned size;		Number of paragraphs requested
;	unsigned * p_segment;	Address to store return value
;
;Exit:
;	AX = error code (0 if successful)
;	*p_segment = failure:	number of free paragraphs
;		     success:	segment address of allocated memory
;
;Uses:
;	BX, CX, ES (Compact/Large model)
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_allocmem,<PUBLIC>,<>

	parmW	_size		; number of paragraphs requested
	parmDP	_p_segment	; address to store return value

cBegin

	mov	bx,(_size)
	callos	allocmem	; try to allocate BX paragraphs of memory
	mov	cx,bx
	jc	failed
;
; Allocation succeeded - store segment value (AX) at *(p_segment)
;
	mov	cx,ax
failed:
;
; AX = return value (INT 21h error code, may be set to 0)
; CX = value to store at *p_segment
;
if sizeD
	les	bx,(_p_segment)
	mov	es:[bx],cx
else
	mov	bx,(_p_segment)
	mov	[bx],cx
endif
	jmp	__dosreturn

cEnd	<nogen>

sEnd

	end
