	page	,132
	title	b_disk
;***
;b_disk.asm - contains the _bios_disk() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _bios_disk() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list

diskinfo_t struc
_drive	dw	?		; 0-3 or 0x80-0x81
_head	dw	?		; 0-?
_track	dw	?		; 0-1023
_sector dw	?		; 0-16
_numsec dw	?		; 0-128
_buffer dd	?
diskinfo_t ends

sBegin	code

	assumes cs,code

page
;***
;unsigned _bios_disk(service, p_diskinfo) - BIOS disk services
;
;Purpose:
;	The function "_bios_disk" allows direct access to the BIOS
;	services to access floppy diskettes and hard disks.
;	These BIOS services are called via INT 13h.
;
;
;Entry:
;	unsigned service - the diskette/disk service requested
;	struct diskinfo_t {
;		unsigned drive;
;		unsigned head;
;		unsigned track;
;		unsigned sector;
;		unsigned nsectors;
;		void far *buffer;
;	} *p_diskinfo	-	contains diskette/disk parameters
;
;Exit:
;	AL = disk status byte (0 means success, otherwise error)
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_bios_disk,<PUBLIC>,<>

	parmW	service
	parmDP	p_diskinfo

cBegin
	mov	ah,byte ptr (service)
if sizeD
	push	ds
	lds	bx,(p_diskinfo)
else
	mov	bx,(p_diskinfo)
endif
	mov	dl,byte ptr [bx._drive]
	cmp	ah,2
	jb	do_int13	; do not load other regs for services 0 and 1

	mov	dh,byte ptr [bx._head]
	mov	cx,[bx._track]
	xchg	ch,cl
	ror	cl,1		; bits 8 and 9 of track are stored
	ror	cl,1		; in the high two bits of CL
	and	cl,0C0H 	; clear off unused lower bits
	or	cl,byte ptr [bx._sector]
	mov	al,byte ptr [bx._numsec]
	les	bx,[bx._buffer]

do_int13:
	int	13H		; request diskette/disk service

if sizeD
	pop	ds
endif

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif

sEnd

	end
