	page	,132
	title	b_keybd
;***
;b_keybd.asm - contains the _bios_keybrd() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _bios_keybrd() function.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

READ		= 00H		; Keyboard read
READY		= 01H		; Keyboard ready
STATUS		= 02H		; Keyboard shiftstatus

NREAD		= 10H		; Enhanced Keyboard read
NREADY		= 11H		; Enhanced Keyboard ready
NSTATUS 	= 12H		; Enhanced Keyboard shiftstatus

NMASK		= 0FH		; Mask to get rid of 'Enhanced' bit

sBegin	code

	assumes cs,code

page
;***
;unsigned _bios_keybrd(service) - BIOS keyboard services
;
;Purpose:
;	The function "_bios_keybrd" performs
;	keyboard services using interrupt 16H.
;
;Entry:
;	unsigned service - specifies which keyboard service is being requested
;
;Exit:
;	For service 0 or 10H, AL = Character code, AH = Scan Code
;	For service 1 or 11H, AX = 0 if no key waiting, otherwise same as service 0
;	For service 2 or 12H, AX = shift byte
;
;	Control+Break is indicated by a return value of 0FFFFH
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_bios_keybrd,<PUBLIC>,<>

	parmB	service

cBegin
	mov	ah,(service)	; ah = service
	mov	dl,ah		; dl = service for later
	and	dl,NMASK	; mask off enhanced bit for later
	int	16H		; request keyboard service
	jnz	chk_brk

	; zero flag set
	cmp	dl,READY	; if (N)READY return 0
	jne	chk_brk

	xor	ax,ax		; return 0 to indicate no key ready
	jmp	short	done

chk_brk:
	cmp	dl,STATUS	; if (N)STATUS, just return ax
	je	done

	or	ax,ax		; For (N)READ and (N)READY
	jnz	done		; map CTRL+BREAK (0) to -1
	dec	ax
done:

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
