	page	,132
	title	b_print
;***
;b_print.asm - contains the _bios_printer() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _bios_printer() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list

sBegin	code

	assumes cs,code

page
;***
;unsigned _bios_printer(service, printer, databyte) - BIOS printer services
;
;Purpose:
;	The function "_bios_printer" performs printer
;	output services using interrupt 17H.
;
;Entry:
;	unsigned service - specifies which printer service is being requested
;	unsigned printer - specifies which printer (0=LPT1, 1=LPT2, etc.)
;	unsigned databyte - specifies the character to be output for service=2
;
;Exit:
;	AL = the BIOS printer status byte
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_bios_printer,<PUBLIC>,<>

	parmW	service
	parmW	printer
	parmW	databyte

cBegin
	mov	ah,byte ptr (service)
	mov	al,byte ptr (databyte)
	mov	dx,word ptr (printer)

	int	17H		; request printer service

	mov	al,ah		; return status bits in AL, not in AH
	mov	ah,0

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
