	page	,132
	title	b_serial
;***
;b_serial.asm - contains the _bios_serialcom() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _bios_serialcom() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list

sBegin	code

	assumes cs,code

page
;***
;unsigned _bios_serialcom(service, serial_port, data) - BIOS serial services
;
;Purpose:
;	The function "_bios_serialcom" allows direct access to
;	the BIOS services to access the serial communication ports.
;	These BIOS services are called via INT 14h.
;
;Entry:
;	unsigned service - the serial communication service requested
;	unsigned serial_port - specifies which serial port (0=COM1:, etc.)
;	unsigned data - port configuration bits
;
;Exit:
;	AH = serial port status bits
;	AL = byte received for service=2
;	   = modem status for service=3
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_bios_serialcom,<PUBLIC>,<>

	parmW	service
	parmW	serial_port
	parmW	portdata

cBegin
	mov	ah,byte ptr (service)
	mov	al,byte ptr (portdata)
	mov	dx,(serial_port)
	int	14H		; request serial communications service

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
