	page	,132
	title	b_timofd
;***
;b_timofd.asm - contains the _bios_timeofday() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _bios_timeofday() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list

sBegin	code

	assumes cs,code

page
;***
;unsigned _bios_timeofday(service, p_timeval) - get/set time of day
;
;Purpose:
;	Calls BIOS time of day function
;
;Entry:
;	If service = 1 Then *p_timeval is the new system clock count
;
;Exit:
;	If service = 0 Then *p_timeval is the current system clock count
;		and AX is 0 or 1 to indicate whether midnight has passed
;		since the last time the system clock count was read or set.
;
;	Else service = 1 and the system clock count is changed and AX = 0
;
;	Any other value for service is invalid and AX = -1 is returned.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_bios_timeofday,<PUBLIC>,<>

	parmW	service 	; function (_TIME_GETCLOCK or _TIME_SETCLOCK)
	parmDP	p_timeval	; address of the clock count value

cBegin
	mov	ax,(service)
	or	ax,ax
	jnz	not_get_clock
	int	1AH
if sizeD
	les	bx,(p_timeval)
	mov	es:[bx],dx
	mov	es:[bx+2],cx
else
	mov	bx,(p_timeval)
	mov	[bx],dx
	mov	[bx+2],cx
endif
	mov	ah,0
	jmp	short done

not_get_clock:
	dec	ax
	mov	ax,-1		; return -1 in case of invalid "service"
	jnz	done
if sizeD
	les	bx,(p_timeval)
	mov	dx,es:[bx]
	mov	cx,es:[bx+2]
else
	mov	bx,(p_timeval)
	mov	dx,[bx]
	mov	cx,[bx+2]
endif
	mov	ah,1
	int	1AH
	xor	ax,ax
done:

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
