	page	,132
	title	chainint - Chain Interrupt
;***
;chainint.asm - Chain interrupt
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Chain from one interrupt handler to another.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

;structure defining the format of the stack when this routine gets control.

intstk	struc
	_es	dw	?
	_ds	dw	?
	_di	dw	?
	_si	dw	?
	_bp	dw	?
	_sp	dw	?
	_bx	dw	?
	_dx	dw	?
	_cx	dw	?
	_ax	dw	?
intstk	ends

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;_chain_intr - Chain interrupt
;
;Purpose:
;	Execute a far jump to the location supplied by the user.
;	This routine is most commonly used to chain interrupt handlers
;	for the same interrupt.  Since the ultimate return address is
;	already on the stack, using this routine to chain to a new address
;	is preferable to issuing a "call" because the stack is not altered.
;
;	_chain_intr must do the following:
;	(1) Clean off the stack frame pushed on by the call to _chain_intr.
;	(2) Take the values on the previous stack and put them in the registers
;	so the the new target will think it got the interrupt directly.
;	(3) Transfer control to the new target location.
;
;	The order of the stack registers is determined by the "interrupt"
;	attribute assigned to the interrupt handler routine address.
;
;Entry:
;	interrupt far * target() = pointer to a far address
;
;Exit:
;	No return.
;Uses:
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_chain_intr,<PUBLIC>,<>

	parmD	target

cBegin

	cli				; turn off interrupts

;Exchange the last two register values on the stack with the target address.

	mov	ax,word ptr[target+2]	;get target address into ax:cx
	mov	cx,word ptr[target]

	pop	bp			;get caller's bp
	mov	sp,bp			;sp = bp = address of interrupt frame

	xchg	ax,[bp]._ax		;move target address onto stack
	xchg	cx,[bp]._cx		;and stack values into registers

;Now pop all values except the bottom two (ax & bx) into the registers

	pop	es
	pop	ds
	pop	di
	pop	si
	pop	bp
	pop	bx		;pop sp into space
	pop	bx
	pop	dx

;We already have ax/cx in the registers and have put the target address
;in their place on the stack.  So just return and we should go to the
;target address with the stack and registers ordered correctly.

dummy	proc far
	ret			;retf
dummy	endp

cEnd	<nogen>

sEnd
	end
