	page	,132
	title	getdiskfree - contains the _dos_getdiskfree() function
;***
;diskfree.asm - contains _dos_getdiskfree()
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_getdiskfree() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	include errno.inc
	.list

diskfree_t	struc
total_clusters	dw	?
avail_clusters	dw	?
sectors_cluster dw	?
bytes_sector	dw	?
diskfree_t	ends

	extrn	__dosreturn:near

sBegin	data
	externW errno
sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;int _dos_getdiskfree(drive, p_diskspace) - return free space on disk drive
;
;Purpose:
;	The function "_dos_getdiskfree" allows the user to determine
;	the number of available clusters on a given disk drive, as well
;	as the total number of clusters, the cluster size (in sectors)
;	and the sector size (in bytes).
;
;Entry:
;	unsigned drive; 	drive to be described (0=default, 1=A:, 2=B:,...)
;	struct diskfree_t {
;		unsigned total_clusters;
;		unsigned avail_clusters;
;		unsigned sectors_per_clusters;
;		unsigned bytes_per_sector;
;	} *p_diskspace; 	address of structure to store information
;
;Exit:
;	AX = 0 if successful
;	else AX = -1 and errno = EINVAL if the "drive" parameter was invalid
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_getdiskfree,<PUBLIC>,<>

	parmB	_drive		; drive to be described
	parmDP	_p_diskspace	; address of structure to store information

cBegin
	mov	dl,(_drive)
	callos	getdskspc	; get free space on the specified drive
	cmp	ax,-1
	jne	drive_okay	; AX == -1 means error
;
; Bad Drive - return AX=-1 after setting errno=EINVAL
;
	mov	[errno],EINVAL
	jmp	short done	; AX = -1
;
; Valid Drive -- store information
;
drive_okay:
	push	si		; preserve register
if sizeD
	push	ds		; preserve register
	lds	si,(_p_diskspace)
else
	mov	si,(_p_diskspace)
endif
	mov	[si.sectors_cluster],ax
	mov	[si.avail_clusters],bx
	mov	[si.bytes_sector],cx
	mov	[si.total_clusters],dx
if sizeD
	pop	ds		; restore register
endif
	pop	si		; restore register
	xor	ax,ax		; return 0 for success
done:

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
