	page	,132
	title	d_creat - Create Handle
;***
;d_creat.asm - Create handle
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "create handle" system calls.
;
;*******************************************************************************


include version.inc
 .xlist
include cmacros.inc
include msdos.inc
include errno.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

	extrn	__dosreturn:near

page
;***
;unsigned _dos_creat(path, attrib, p_handle), _dos_creatnew - Create handle
;
;Purpose:
;	Create a handle:
;		_dos_creat - Direct interface to DOS "create handle"
;		system call (int 21h,3Ch).
;
;		_dos_creatnew - Direct interface to DOS "create new handle"
;		system call (int 21h,5Bh).
;
;Entry:
;	char *path	= pointer to pathname of new file
;	unsigned attrib = file attribute
;	int *p_handle	= new file handle (returned)
;
;Exit:
;	returns:
;	 0 = success
;		int *p_handle = the new file handle returned by DOS
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	AX, BX, CX, DX, ES
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_creatnew,<PUBLIC>,<>

	parmDP	path
	parmW	attrib
	parmDP	p_handle

cBegin
	mov	bh,DOS_createnew	;bh = system call value
	jmp	short common		;join common code
cEnd	nogen

cProc	_dos_creat,<PUBLIC>,<>

	parmDP	path
	parmW	attrib
	parmDP	p_handle

cBegin
	mov	bh,DOS_create		;bh = system call value
common: 				;common code

;Get the user's values
;bh = system call value

if sizeD
	push	ds			;save ds
	lds	dx,[path]		;get pointer to pathname
else
	mov	dx,[path]
endif
	mov	cx,[attrib]		;file attributes

;Issue the appropriate system call
;bh = system call value

	mov	ah,bh			;system call value into ah
	callos				;issue the create call
if sizeD
	pop	ds			;restore ds
endif
	jnc	retok			;no error
	cmp	ax,E_exist		;file exists error?
	stc				;make sure carry is still set
	jne	create_rtn		;some other error
	mov	ah,EEXIST		;set ah to correct Xenix error code
	jmp	short create_rtn	;error return explicitly setting errno

;Return the file handle to the caller
;ax = file handle

retok:
if sizeD
	les	bx,[p_handle]		;get address of handle
	mov	es:[bx],ax		;store the file handle
else
	mov	bx,[p_handle]		;get address of handle
	mov	[bx],ax 		;store the file handle
endif

create_rtn:
	jmp	__dosreturn		; return 0 if successful

cEnd	<nogen>

sEnd
	end
