	page	,132
	title	d_find - Find File
;***
;d_find.asm - Find file
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "find file" system calls.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

	extrn	__dosreturn:near

page
;***
;unsigned _dos_findfirst(path, attrib, p_buf), _dos_findnext(p_buf) - Find file
;
;Purpose:
;	Find a file:
;
;	_dos_findfirst	Direct interface to the DOS "find first file" system
;			call (int 21h,4Eh).
;
;	_dos_findnext	Direct interface to the DOS "find next file" system
;			call (int 21h,4Fh).
;
;Entry:
;
; _dos_findfirst:
;	char *path	= pointer to pathname of file
;	unsigned attrib = attributes to match
;	find_t *p_buf	= DTA buffer area
;
; _dos_findnext:
;	find_t *p_buf	= DTA buffer area
;
;Exit:
;	returns:
;	 0 = success
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	BX,CX,DX,ES
;
;Exceptions:
;
;
;*******************************************************************************

cProc	_dos_findnext,<PUBLIC>,<>

	parmDP	p_bufnext

cBegin

	push	ds			;save ds
	mov	al,DOS_findnext 	;al = findnext sys call value
if sizeD
	lds	dx,[p_bufnext]		;get the user's DTA address
else
	mov	dx,[p_bufnext]		;get the user's DTA address
endif
	jmp	short common		;join common code

cEnd	<nogen>


cProc	_dos_findfirst,<PUBLIC>,<>

	parmDP	path
	parmW	attrib
	parmDP	p_buffirst

cBegin

	push	ds			;save ds
	mov	al,DOS_findfirst	;al = findfirst sys call value
if sizeD
	lds	dx,[p_buffirst] 	;get the user's DTA address
else
	mov	dx,[p_buffirst] 	;get the user's DTA address
endif

;Common code
;   (1) Save DTA
;   (2) Set up user's DTA
;   (3) Issue the findfirst/next call
;   (4) Restore original DTA
;[*NOTE*: This code counts on the fact that getDMA/setDMA calls do NOT
;trash AL.]
;al = first/next system call value, ds:dx = new DTA address

common:
	callos	getDMA			;es:bx = current DTA
	callos	setDMA			;set up the user's DTA

;If findfirst, get the user's find first parameters.
;al = first/next system call value, es:bx = saved DTA address

	cmp	al,DOS_findfirst	;sys call == findfirst ??
	jne	calldos 		;if not findfirst, do the call
if sizeD
	lds	dx,[path]		;get the pathname
else
	mov	dx,[path]		;get the pathname
endif
	mov	cx,[attrib]		;attributes to match

;Issue the find system call
;al = system call value, es:bx = saved DTA address

calldos:
	mov	ah,al			;system call value into ah
	callos				;issue the find system call

	push	ax			;save return value
	lahf				;and carry flag
	push	ax

;Restore the original DTA address
;es:bx = original DTA address

	mov	dx,es
	mov	ds,dx
	mov	dx,bx			;ds:dx = old DTA address
	callos	setDMA			;set up the user's DTA

;Return result of the earlier findfirst/next call

	pop	ax			;get carry flag back
	sahf				;restore carry flag
	pop	ax			;restore ax value

	pop	ds			;restore ds
	jmp	__dosreturn		; return 0 if successful

cEnd	<nogen>

sEnd
	end
