	page	,132
	title	d_getvec - Get Interrupt Vector
;***
;d_getvec.asm - Get interrupt vector
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "get interrupt vector" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;far *_dos_getvect(interrupt) - Get interrupt vector
;
;Purpose:
;	Direct interface to the DOS "get interrupt vector"
;	system call (int 21h,35h).
;
;Entry:
;	unsigned interrupt = interrupt vector value
;
;Exit:
;	Returns the current interrupt handle for the specified
;	interrupt, if any.  There is no error return.
;
;Uses:
;	BX
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_getvect,<PUBLIC>,<>

	parmW	intnum

cBegin

	mov	ax,[intnum]		;get the interrupt number
	callos	getvector		;get the interrupt handler
	mov	dx,es			;return current handler in DX:AX
	mov	ax,bx

cEnd

sEnd
	end
