	page	,132
	title	d_gfile - Get File Attributes
;***
;d_gfile.asm - Get file attributes
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "get file attribute" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

	extrn	__dosreturn:near

page
;***
;unsigned _dos_getfileattr(path, p_attrib) - Get file attributes
;
;Purpose:
;	Direct interface to the DOS "get file attribute"
;	system	call (int 21h,43h/al=0).
;
;Entry:
;	char *path		= pointer to pathname of file
;	unsigned *p_attrib	= area to receive attributes
;
;Exit:
;	returns:
;	 0 = success
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	BX,CX,DX,ES
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_getfileattr,<PUBLIC>,<>

	parmDP	path
	parmDP	p_attrib

cBegin

;Get pathname of file.

if sizeD
	push	ds			;save ds
	lds	dx,[path]		;get pathname of file
else
	mov	dx,[path]		;get pathname of file
endif

;Issue the getfileattr call
;ds:dx = pathname

	mov	ax,DOS_filemode SHL 8	;ah = call / al = 0 = get attr
	callos				;get attributes
if sizeD
	pop	ds			;restore ds
endif
	jc	return			;if error...

;Return the file attributes to the caller
;cx = file attributes

if sizeD
	les	bx,[p_attrib]		;get address of attributes area
	mov	es:[bx],cx		;store the file attributes
else
	mov	bx,[p_attrib]		;get address of attributes area
	mov	[bx],cx 		;store the file attributes
endif

return:
	jmp	__dosreturn		; return 0 if successful

cEnd	<nogen>

sEnd
	end
