	page	,132
	title	d_gftime - Get File Date/Time
;***
;d_gftime.asm - Get file date/time
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "get file date/time" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

	extrn	__dosreturn:near

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;unsigned _dos_getftime(handle, p_date, p_time) - Get file date/time
;
;Purpose:
;	Direct interface to the DOS "get file date/time"
;	system call (int 21h,57h/al=0).
;
;Entry:
;	int handle		= handle of file
;	unsigned *p_date	= pointer to area to receive date
;	unsigned *p_time	= pointer to area to receive time
;
;Exit:
;	returns:
;	 0 = success
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	BX,CX,DX,ES
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_getftime,<PUBLIC>,<>

	parmW	handle
	parmDP	p_date
	parmDP	p_time

cBegin

;Get the date/time of the file

	mov	bx,[handle]		;get the file handle
	mov	ax,DOS_filedate SHL 8	;ah = call / al = 0 = get date/time
	callos				;get date/time
	jc	return			;if error...

;Return the date/time to caller
;cx = time, dx = date

if sizeD
	les	bx,[p_time]		;get address of time area
	mov	es:[bx],cx		;store the file time
	les	bx,[p_date]		;get address of date area
	mov	es:[bx],dx		;store the file date
else
	mov	bx,[p_time]		;get address of time area
	mov	[bx],cx 		;store the file time
	mov	bx,[p_date]		;get address of date area
	mov	[bx],dx 		;store the file date
endif

return:
	jmp	__dosreturn		; return 0 if successful

cEnd	<nogen>

sEnd
	end
