	page	,132
	title	d_keep - Keep Process
;***
;d_keep.asm - Keep process
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "keep process" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

	externP _cexit		; C lib termination routine

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;unsigned _dos_keep(retcode, memsize) - Keep process
;
;Purpose:
;	Direct interface to the DOS "keep process"
;	system call (int 21h,31h) -- terminate and stay resident.
;
;Entry:
;	unsigned retcode = return code
;	unsigned memsize = memory size in paragraphs
;
;Exit:
;	No return.
;	This call causes the calling process to terminate.
;
;Uses:
;	DX
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_keep,<PUBLIC>,<>

	parmW	retcode
	parmW	memsize

cBegin

	callcrt _cexit			;execute the termination sequence

	mov	ax,[retcode]		;get the return code
	mov	dx,[memsize]		;memory size (in paragraphs)
	callos	keep			;issue the keep process call

cEnd

sEnd
	end
