	page	,132
	title	d_lock - Lock/Unlock File Region
;***
;d_lock.asm -
;
;	Copyright (c) 1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "lock/unlock file region" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

	extrn	__dosreturn:near

page
;***
;unsigned _dos_lock(handle, mode, origin, length) - Lock/unlock region
;	of file from origin to origin + length
;
;Purpose:
;	Direct interface to the DOS "lock/unlock file region" system call
;	(int 21h, 5Ch).
;
;Entry:
;	int handle	     = handle of file to close
;	int mode	     = 0 for lock region
;			       1 for unlock region
;	unsigned long origin = start of region to be locked/unlocked
;	unsigned long length = length of region to be locked/unlocked
;
;Exit:
;	returns:
;	 0 = success
;	!0 = failure (then returns DOS error code, errno = appropriate
;	     mapped value)
;Uses:
;	AX, BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_lock,<PUBLIC>,<si,di>

	parmW	handle
	parmW	mode
	parmD	origin
	parmD	len

cBegin

;Get the user's values

	mov	bx,[handle]			;bx = file handle
	mov	ax,[mode]			;al = mode (0 or 1)
	mov	dx,word ptr [origin]
	mov	cx,word ptr [origin + 2]	;cx:dx = origin
	mov	di,word ptr [len]
	mov	si,word ptr [len + 2]		;si:di = len

	callos	locking

	jmp	__dosreturn			;return 0 if successful

cEnd	<nogen>

sEnd
	end
