	page	,132
	title	d_open - Open Handle
;***
;d_open.asm - Open handle
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "open handle" system call.
;
;*******************************************************************************


include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

	extrn	__dosreturn:near

page
;***
;unsigned _dos_open(path, mode, p_handle) - Open handle
;
;Purpose:
;	Open a handle:	Direct interface to the DOS "open handle" system
;			call (int 21h,3Dh).
;
;Entry:
;	char *path	= pointer to pathname of file
;	unsigned mode	= file access mode
;	int *p_handle	= new file handle (returned)
;
;Exit:
;	 0 = success
;		int *p_handle = the new file handle returned by DOS
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	AX, BX, CX, DX, ES
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_open,<PUBLIC>,<>

	parmDP	path
	parmW	mode
	parmDP	p_handle

cBegin

;Get the user's values

if sizeD
	push	ds			;save ds
	lds	dx,[path]		;get pointer to pathname
else
	mov	dx,[path]
endif
	mov	ax,[mode]		;file access mode

;Issue the open handle system call

	callos	open			;issue the open system call
if sizeD
	pop	ds			;restore ds
endif
	jc	return			;error...

;Return the file handle to the caller
;ax = file handle

if sizeD
	les	bx,[p_handle]		;get address of handle
	mov	es:[bx],ax		;store the file handle
else
	mov	bx,[p_handle]		;get address of handle
	mov	[bx],ax 		;store the file handle
endif

return:
	jmp	__dosreturn		; return 0 if successful

cEnd	<nogen>

sEnd
	end
