	page	,132
	title	d_rdwr - Read/Write Handle
;***
;d_rdwr.asm - Read/write handle
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "read/write handle" system calls.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
include defsegs.inc
 .list

ifndef _WINDOWS
	_DEBUGSCREEN equ 1		; debug screen swapping
endif

	extrn	__dosreturn:near

ifdef _DEBUGSCREEN

CrtDefSegs  <dbdata>

sBegin	dbdata				;
	assumes ds,data 		;Used to do the running under
externW 	__aDBswpflg		;a debugger screen swapping
externW 	__aDBswpchk		;
sEnd	dbdata				;
	extrn	__aDBdoswp:ABS		;

endif	;_DEBUGSCREEN

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;unsigned _dos_read(handle, p_buffer, cnt, p_bytes), _dos_write - read/write handle
;
;Purpose:
;	Read/write handle:
;
;	_dos_read:	Direct interface to the DOS "read handle" system
;			call (int 21h,3Fh).
;
;	_dos_write:	Direct interface to the DOS "write handle" system
;			call (int 21h,40h).
;
;Entry:
;	int handle		= File handle
;	void far *p_buffer	= Pointer to buffer
;	unsigned cnt		= Number of bytes to read/write
;	unsigned *p_bytes	= Number of bytes read/written (returned)
;
;Exit:
;	 0 = success
;		number of bytes read/written is returned in p_bytes
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	BX,CX,DX
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_read,<PUBLIC>,<>

	parmW	handle
	parmD	p_buffer
	parmW	cnt
	parmDP	p_bytes

cBegin

	mov	ah,DOS_read		;read handle sys call value
	jmp	short common		;join common code

cEnd	<nogen>


cProc	_dos_write,<PUBLIC>,<>

	parmW	handle
	parmD	p_buffer
	parmW	cnt
	parmDP	p_bytes

cBegin

	mov	ah,DOS_write		;write handle sys call value
	;fall thru

;Common read/write code
;bh = system call value

common:
	mov	bx,[handle]		;get file handle
	mov	cx,[cnt]		;get byte count

ifdef _DEBUGSCREEN
	cmp	__aDBswpflg,__aDBdoswp	;Aware debugger as parent?
	jne	@F			;No -- skip
	call	__aDBswpchk		;Yes -- see if we need to swap screens
@@:
endif	;_DEBUGSCREEN

	push	ds			;save ds
	lds	dx,[p_buffer]		;get the buff addr (always far)


	callos				;issue the read/write call
	pop	ds			;must restore DS a.s.a.p.
	jc	return			;if error...

;Return the number of bytes read/written to the user.
;ax = read/written byte count

if sizeD
	les	bx,[p_bytes]		;get address of byte count
	mov	es:[bx],ax		;store the byte count
else
	mov	bx,[p_bytes]		;get address of byte count
	mov	[bx],ax 		;store the byte count
endif

;Return to the caller

return:
	jmp	__dosreturn		;return 0 if successful

cEnd	<nogen>

sEnd

	end
