	page	,132
	title	d_seek - Position file pointer
;***
;d_seek.asm - Position file pointer
;
;	Copyright (c) 1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "move file pointer" system call.
;
;*******************************************************************************


include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

	extrn	__dosretax:near

page
;***
;unsigned long _dos_seek(handle, offset, origin) - Seek file pointer
;
;Purpose:
;	Seek file pointer: Direct interface to the DOS "move file pointer"
;	system call (int 21h, 42h).
;
;Entry:
;	int handle		= open file handle
;	unsigned long offset	= offset of new position relative to the origin
;				  specified below
;	int origin		= 0 (seek relative to beginning of the file)
;				  1 (seek relative to current file position)
;				  2 (seek relative to end of file)
;
;Exit:
;	If successful, the offset, in bytes, from the beginning of the file
;	is returned.
;	Otherwise, returns (unsigned long)(-1L) and sets __doserrno/errno.
;
;Uses:
;	AX, BX, CX, DX
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_seek,<PUBLIC>,<>

	parmW	handle
	parmD	offst
	parmW	origin

cBegin

;Get the user's values

	mov	bx,handle
	mov	dx,word ptr [offst]
	mov	cx,word ptr [offst + 2]
	mov	ax,origin		;seek origin

;Issue the move file pointer system call

	callos	lseek

	jmp	__dosretax		;return 0 if successful

cEnd	<nogen>

sEnd
	end
