	page	,132
	title	d_setvec - Set Interrupt Vector
;***
;d_setvec.asm - Set interrupt vector
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "set interrupt vector" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;void _dos_setvect(interrupt, handler) - Set interrupt vector
;
;Purpose:
;	Direct interface to the DOS "set interrupt vector"
;	system call (int 21h,25h).
;
;Entry:
;	unsigned interrupt	= interrupt vector value
;	far *handler		= pointer to address of new handler
;
;Exit:
;	No return value.
;
;Uses:
;	BX
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_setvect,<PUBLIC>,<>

	parmW	intnum
	parmD	handler

cBegin

	mov	ax,[intnum]		;set the interrupt number
	push	ds			;save ds
	lds	dx,[handler]		;address of handler (always far)

	callos	setvector		;set the interrupt handler

	pop	ds			;restore ds
	xor	ax,ax			;routine is supposed to return void...
cEnd

sEnd
	end
