	page	,132
	title	d_sfile - Set File Attributes
;***
;d_sfile.asm - Set file attributes
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "set file attribute" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

sBegin	code

	assumes cs,code
	assumes ds,data

	extrn	__dosreturn:near

page
;***
;unsigned _dos_setfileattr(path, attrib) - Set file attributes
;
;Purpose:
;	Direct interface to the DOS "set file attribute"
;	system call (int 21h,43h/al=1).
;
;Entry:
;	char *path	= pointer to pathname of file
;	unsigned attrib = new attributes
;
;Exit:
;	 0 = success
;
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	BX,CX,DX,ES
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_setfileattr,<PUBLIC>,<>

	parmDP	path
	parmW	attrib

cBegin

;Get arguments to system call.

if sizeD
	push	ds			;save ds
	lds	dx,[path]		;get pathname of file
else
	mov	dx,[path]		;get pathname of file
endif
	mov	cx,[attrib]		;get new attributes

;Issue the setfileattr call
;cx = attributes, ds:dx = pathname

	mov	ax,(DOS_filemode SHL 8) + 1	;ah = call / al = 1 = set attr
	callos					;set attributes
if sizeD
	pop	ds			;restore ds
endif
	jmp	__dosreturn		; return 0 if successful

cEnd	<nogen>

sEnd
	end
