	page	,132
	title	d_sftime - Set File Date/Time
;***
;d_sftime.asm - Set file date/time
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Direct interface to DOS "set file date/time" system call.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

	extrn	__dosreturn:near

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;unsigned _dos_setftime(handle, date, time) - Set file date/time
;
;Purpose:
;	_dos_setftime	Direct interface to the DOS "set file date/time"
;			system	call (int 21h,57h/al=1).
;
;Entry:
;	int handle	= file handle
;	unsigned date	= new date
;	unsigned time	= new time
;
;Exit:
;	 0 = success
;
;	!0 = failure
;		return value = error code returned by DOS
;		errno = appropriate mapped value
;Uses:
;	BX,CX,DX
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_dos_setftime,<PUBLIC>,<>

	parmW	handle
	parmW	date
	parmW	time

cBegin

;Get arguments to system call.

	mov	bx,[handle]	;get file handle
	mov	cx,[time]	;get time
	mov	dx,[date]	;get date

;Issue the setftime call

	mov	ax,(DOS_filedate SHL 8) + 1	;ah=call / al=1=set date/time
	callos					;set date/time
	jmp	__dosreturn		; return 0 if successful

cEnd	<nogen>

sEnd
	end
