	page	,132
	title	getdate
;***
;getdate.asm - contains the _dos_getdate() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_getdate() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list

dosdate_t	struc
day	db	?
month	db	?
year	dw	?
dayofwk db	?
dosdate_t	ends

sBegin	code

	assumes cs,code

page
;***
;void _dos_getdate(p_date) - return the current date
;
;Purpose:
;	The function "_dos_getdate" returns the current date, broken down
;	into the year (1980-2099), the month (1-12), the day (1-31), and
;	the day of the week (0-6, Sun=0, Mon=1, ..., Sat=6).
;	It uses INT 21h, Function 2Ah to get the date.
;
;Entry:
;	struct dosdate_t {
;		unsigned char day;
;		unsigned char month;
;		unsigned int  year;
;		unsigned char dayofweek;
;	} * p_date;		address of structure to store date
;
;Exit:
;	The structure pointed to by "p_date" contains the broken down date
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_getdate,<PUBLIC>,<>

	parmDP	_p_date 	; address of structure to store date

cBegin
	callos	getdate 	; get the date from the DOS
if sizeD
	push	ds
	lds	bx,(_p_date)
else
	mov	bx,(_p_date)
endif
	mov	[bx.year],cx
	mov	[bx.month],dh
	mov	[bx.day],dl
	mov	[bx.dayofwk],al
if sizeD
	pop	ds
endif
	xor	ax,ax		; return nothing useful

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
