	page	,132
	title	getdrive - contains the _dos_getdrive() function
;***
;getdrive.asm - contains _dos_getdrive()
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_getdrive() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list

sBegin	code

	assumes cs,code

page
;***
;unsigned _dos_getdrive(p_drive) - return current defd rive (1=A:, 2=B:, etc.)
;
;Purpose:
;	The function "_dos_getdrive" allows the user to determine
;	the current default drive, via INT 21H function 19H.
;
; NOTE: INT 21h Function 19h returns (0=A:, 1=B:, etc.) but _dos_getdrive()
;	returns values (1=A:, 2=B:, etc.) consistent with other DOS functions.
;
;Entry:
;	unsigned * p_drive;	address to store drive
;
;Exit:
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_getdrive,<PUBLIC>,<>

	parmDP	_p_drive	; address to store drive

cBegin

	callos	currentd	; get current drive

	inc	ax		; A: = 1, B: = 2, etc.
	mov	ah,0
if sizeD
	les	bx,(_p_drive)
	mov	es:[bx],ax
else
	mov	bx,(_p_drive)
	mov	[bx],ax
endif
	xor	ax,ax		; Do NOT return something useful --

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
