	page	,132
	title	gettime
;***
;gettime.asm - contains the _dos_gettime() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_gettime() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list

dostime_t	struc
hour	db	?
minute	db	?
second	db	?
hsecond db	?
dostime_t	ends

sBegin	code

	assumes cs,code

page
;***
;void _dos_gettime(p_time) - return the current time
;
;Purpose:
;	The function "_dos_gettime" returns the current time, broken
;	down into the hour (0-23), minute (0-59), second (0-59), and
;	the hundredth of a second (0-99).
;	It uses INT 21h, Function 2Ch to get the time.
;
;Entry:
;	struct dostime_t {
;		unsigned char hour;
;		unsigned char minute;
;		unsigned char second;
;		unsigned char hsecond;
;	}* p_time;		address of structure to store time
;
;Exit:
;	The structure pointed to by "p_time" contains the broken down time
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_gettime,<PUBLIC>,<>

	parmDP	_p_time 	; address of structure to store time

cBegin
	callos	gettime 	; get the time from the DOS
if sizeD
	push	ds
	lds	bx,(_p_time)
else
	mov	bx,(_p_time)
endif
	mov	[bx.hour],ch
	mov	[bx.minute],cl
	mov	[bx.second],dh
	mov	[bx.hsecond],dl
if sizeD
	pop	ds
endif
	xor	ax,ax		; return nothing useful

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
