	page	,132
	title	harderr - Hard Error Handling
;***
;harderr.asm - Hard Error Handling
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Contains code that allows users to gain control when a hard
;	error (int 24h) occurs.  Specifically, routines _harderr
;	and _hardresume are contained in this module.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

externW _dataseg			; holds DGROUP segment value

;Make the following available to _hardretn

public	__oldsp 			;sp save area
public	__hardretn_return		;common hard err return code

sBegin	data

	assumes ds,data

	handler_off	dw	0	;user handler (offset)
	handler_seg	dw	0	;user handler (segment)

	__oldsp 	dw	0	;sp save area

sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;void _harderr(handler) - Hard error handling
;
;Purpose:
;	Allow the user to specify a routine that gets control when
;	a hard error (int 24h) occurs.
;
;Entry:
;	(far *handler)()	= pointer to address of hard error handler
;
;Exit:
;	No return value.
;
;Uses:
;	AX,DX,ES
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_harderr,<PUBLIC>,<>

	parmD	handler

cBegin

	les	dx,[handler]		;address of handler (always far)
	mov	[handler_seg],es	;save address of user handler
	mov	[handler_off],dx

	push	ds				;save ds
	mov	ax,cs				;make ds = segment of handler
	mov	ds,ax
	mov	dx,codeOFFSET [hardtrap]	;ds:dx = addr hard err handler
	mov	al,24h				;interrupt number = 24h
	callos	setvector			;set the hard err handler

	pop	ds			;restore ds
	xor	ax,ax			;routine is supposed to return void...
cEnd


page
;***
; harderr - Hard error handling routine
;
;Purpose:
;	This routine gets control when a hard error (int 24h) occurs,
;	sets things up, and calls the user specified handling routine.
;
;Entry:
;	No entry values.
;	On entry, the stack has two interrupt stack frames:
;		(a) the original int 21h frame
;		(b) the int 24h frame
;
;Exit:
;	After calling the user's hard error handler, control may never
;	return to this routine.
;
;Uses:
;
;Exceptions:
;	None.
;
;*******************************************************************************

cProc	hardtrap

cBegin	<nogen>

	assumes ds,nothing
	assumes ss,nothing
	assumes es,nothing

;Save the current state of the world.
;(Same save order used by the int 21h.)

	push	es
	push	ds
	push	bp
	push	di
	push	si
	push	dx
	push	cx
	push	bx
	push	ax

;Make sure ds is set right.  Then save sp.

	mov	bx,cs:[_dataseg];ds = DGROUP
	mov	ds,bx
	assumes ds,data

	mov	[__oldsp],sp	;save sp for later

;Push the appropriate arguments on the stack and call the user's
;hard error handling routine.  The int 24h values that the user wants
;to see are:
;	ax	= error code
;	di	= error code
;	bp:si	= address of device header

	push	bp
	push	si
	push	di
	push	ax

	call	dword ptr [handler_off] ;call the user's hard err handler

;We may never return here from the user's routine.
;If we do, pop the appropriate values off the stack, preserve the ax value
;returned by the user's handler, and return.
;ax = return value

_hardresume_return:		;_hardresume enters here

	mov	sp,[__oldsp]	;restore sp

__hardretn_return:		;_hardretn enters here

	add	sp,2		;skip over ax
	pop	bx
	pop	cx
	pop	dx
	pop	si
	pop	di
	pop	bp
	pop	ds
	pop	es

	assumes ds,nothing

	iret			;return from int

cEnd	<nogen>

	assumes cs,code
	assumes ds,data

page
;***
;_hardresume(result) - Return to DOS after hard error handling
;
;Purpose:
;	Allow the user to return to DOS after handling a hard error.
;
;Entry:
;	int result	= 0 (ignore), 1 (retry), 2 (abort), or 3 (fail).
;
;Exit:
;	Never returns to caller; returns to int 21h DOS code that
;	generated the int 24h hard error.
;
;Uses:
;	AX,BX,CX,DX,SP
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_hardresume,<PUBLIC>,<>

	parmW	result

cBegin

	mov	ax,[result]		;get return value
	jmp	_hardresume_return	;join common handler return

cEnd	<nogen>


sEnd
	end
