	page	,132
	title	hardretn - Return To System Call After Hard Error Handling
;***
;hardretn.asm - Return to system call after hard error handling
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Contains _hardretn which allows a user to return from a hard error
;	handling routine to the system call that caused the original error.
;
;*******************************************************************************

include version.inc
 .xlist
include cmacros.inc
include msdos.inc
 .list

IRETSIZE	equ	6	;size of iret stack frame (bytes)
INTSIZE 	equ	18	;size of int21 stack frame (bytes)
CARRYCALL	equ	38h	;sys calls 38h and above set carry on errors

externW _oldsp			;sp save area
externP _hardretn_return	;common harderr return code

sBegin	data

	assumes ds,data

	;--- System call error bit table ---
	;The following table is a series of bits indexed by system call value.
	;If a bit is set, the corresponding system call can return an error;
	;otherwise, it cannot.	Table is for those int 21h system calls that
	;do not use the carry bit to indicate that an error has occurred (e.g.,
	;system calls 0h - 37h).

	labelW	_callerr		;system call bit table
		dw	 0001h		;calls 0h - Fh
		dw	0F308h		;calls 10h - 1Fh
		dw	 1054h		;calls 10h - 2Fh
		dw	 1200h		;calls 10h - 3Fh

sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;void _hardretn(errval) - Return to system call after hard error handling
;
;Purpose:
;	Allow the user to return from the handler routine to the original
;	code that caused the hard error.
;
;Entry:
;	int errval = error value to be returned to original code
;
;Exit:
;	Never returns to caller; returns to user code that caused the
;	original int 21h (which in turn caused the int 24h error).
;
;Uses:
;
;Exceptions:
;	None
;
;*******************************************************************************

cProc	_hardretn,<PUBLIC>,<>

	parmW	errval

cBegin

;Issue a system call to put DOS in a stable state.

	callos	version 	;alters AX,BX,CX

;Get rid of the int 24h stack frame and all the temps pushed on by hardtrap.

	mov	sp,ds:[_oldsp]		;restore sp
	add	sp,IRETSIZE+INTSIZE	;make sp point to int 21h frame

;Depending on the system call originally issued, do the following:
;
;	if syscall# >= 0x38 {
;		set carry to indicate error
;		AX = user-supplied error value
;		}
;	else if syscall# can return error {
;		AL = 0xFF
;		}
;	return to system call that caused original error
;

	mov	bx,sp			;sp into base register
	mov	ax,ss:[bx]		;get sys call off top-of-stack
	cmp	ah,CARRYCALL		;sys call one that can set carry ??
	jb	hardret1		;nope - more checking needed

;System call is greater than or equal to "CARRYCALL" value.
;Set carry and ax for the error return.  Then join common return code.
;bx = sp

	or	byte ptr[bx+IRETSIZE+INTSIZE-2],1 ;set int 21h carry bit
	mov	ax,[errval]		;user's error code into ax
	jmp	_hardretn_return	;join common hard handler return code

;System call is less than "CARRYCALL" and, thus, does not set carry on error.
;See if the call can take an error or not.   Check the _callerr bit table.
;If bit=1, call can return an error; if bit=0, call can NOT return an error.
;
;ax = ax value from int 21h stack frame (ah = sys call #)

hardret1:
	mov	dx,ax		;save original ax value for later
	mov	cl,4		;shift value = 4 (one hex digit)
	shr	dx,cl		;shift sys call value right
	shr	dl,cl		;shift lo-hex digit right again
				;dh = word offset / dl = bit offset in the word

	mov	cl,dl		;move bit offset into shift register
	inc	cl		;make bit offset 0-based
	mov	bl,dh		;move word offset into bl
	xor	bh,bh		;zero out upper byte (bx = word offset)
	shl	bx,1		;make bx a byte-offset value
				;bx = byte offset of word / cl = bit offset

	mov	dx,[bx+_callerr];get appropriate word out of table
	shl	dx,cl		;shift the sys call bit into carry

	jnc	hardret2	;no carry - sys call can NOT return an error,
				;do not modify ax

				;carry set - sys call CAN return an error,
	mov	al,0FFh 	;set al = FFh to indicate error
	;fall thru

;Return via common harderr return code
;ax = value to be returned to user

hardret2:
	jmp	_hardretn_return

cEnd	<nogen>


sEnd
	end
