	page	,132
	title	outpw
;***
;outpw.asm - contains outpw()
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	contains the function "outpw()"
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	.list

sBegin	code

	assumes cs,code

page
;***
;unsigned _outpw(port, value) - write word value to I/O port
;
;Purpose:
;	Write the given word to the specified I/O port
;
;Entry:
;	unsigned port - port to write word to
;	unsigned value - word value to write to port
;
;Exit:
;	AX = value
;
;Uses:
;	DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_outpw,<PUBLIC>,<>

	parmW	port
	parmW	value

cBegin

	mov	dx,[port]
	mov	ax,[value]
	out	dx,ax

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
