	page	,132
	title	setblock - contains the _dos_setblock() function
;***
;setblock.asm - contains _dos_setblock()
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_setblock() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list

	extrn	__dosreturn:near

	assumes cs,code

sBegin	code

page
;***
;unsigned _dos_setblock(size, segment, p_segment) - resize memory directly from DOS
;
;Purpose:
;	The function "_dos_setblock" allows the user to resize
;	memory directly from the DOS, via INT 21H function 4AH.
;	If the resizing fails, the maximum size to which the
;	segment could be resized is returned.
;
;Entry:
;	unsigned size;		Number of paragraphs requested
;	unsigned segment;	Segment to be resized
;	unsigned * p_segment;	Address to store return value in case of error
;
;Exit:
;	AX = error code (0 if successful)
;	*p_segment = failure:	maximum size to which segment could be resized
;		     success:	not changed
;
;Uses:
;	BX, CX, ES
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_setblock,<PUBLIC>,<>

	parmW	_size		; number of paragraphs requested
	parmW	_segment	; segment to be resized
	parmDP	_p_maxsize	; address to store maximum size in case of failure

cBegin

	mov	es,(_segment)
	mov	bx,(_size)
	callos	setmem		; try to resize ES segment to be BX paragraphs
	jnc	succeeded
;
; Allocation failed - store maximum size (BX) at *(p_maxsize)
;
	mov	cx,bx
if sizeD
	les	bx,(_p_maxsize)
	mov	es:[bx],cx
else
	mov	bx,(_p_maxsize)
	mov	[bx],cx
endif

succeeded:
	jmp	__dosreturn

cEnd	<nogen>

sEnd

	end
