	page	,132
	title	setdate
;***
;setdate.asm - contains the _dos_setdate() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_setdate() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	include errno.inc
	.list

dosdate_t	struc
day	db	?
month	db	?
year	dw	?
dayofwk db	?
dosdate_t	ends

sBegin	data
	externW errno
sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;unsigned _dos_setdate(p_date) - return the current date
;
;Purpose:
;	The function "_dos_setdate" allows the user to set the
;	date by year (1980-2099), month (1-12), and day (1-31).
;	It uses INT 21h, Function 2Bh to set the date.
;
;Entry:
;	struct dosdate_t {
;		unsigned char day;
;		unsigned char month;
;		unsigned int  year;
;		unsigned char dayofweek;
;	} *p_date;		address of structure to store date
;
;Exit:
;	The system date is changed and AX = 0 for success,
;	else AX = -1 and errno = EINVAL for an invalid date
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_setdate,<PUBLIC>,<>

	parmDP	_p_date 	; address of structure to store date

cBegin

if sizeD
	push	ds
	lds	bx,(_p_date)
else
	mov	bx,(_p_date)
endif
	mov	cx,[bx.year]
	mov	dh,[bx.month]
	mov	dl,[bx.day]
if sizeD
	pop	ds
endif
	callos	setdate 	; AL = 0 for success, -1 for error
	cmp	al,0FFH
	mov	ax,0		; MOV does not change flags
	jne	no_error
	mov	[errno],EINVAL
	dec	ax		; AX = -1
no_error:

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
