	page	,132
	title	setdrive - contains the _dos_setdrive() function
;***
;setdrive.asm - contains _dos_setdrive()
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_setdrive() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	.list

sBegin	code

	assumes cs,code

page
;***
;unsigned _dos_setdrive(drive, p_ndrive) - change default drive (1=A:, 2=B:, etc.)
;
;Purpose:
;	The function "_dos_setdrive" allows the user to change
;	the current default drive, via INT 21H function 0EH.
;	It also returns the number of valid drives in the system.
;
;	NOTE: INT 21h Function 19h accepts (0=A:, 1=B:, etc.) but
;	_dos_setdrive() uses values (1=A:, 2=B:, etc.) consistent
;	with other DOS functions.
;
;Entry:
;	unsigned drive; 	drive to be the default
;	unsigned * p_ndrives;	address to store drive
;
;Exit:
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_setdrive,<PUBLIC>,<>

	parmB	_drive		; drive to be default drive
	parmDP	_p_ndrives	; address to store number of valid drives

cBegin

	mov	dl,(_drive)
	dec	dx
	callos	selectdisk	; set current drive

	mov	ah,0
if sizeD
	les	bx,(_p_ndrives)
	mov	es:[bx],ax
else
	mov	bx,(_p_ndrives)
	mov	[bx],ax
endif
	xor	ax,ax		; Do NOT return something useful --

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
