	page	,132
	title	settime
;***
;settime.asm - contains the _dos_settime() function
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	This module contains the _dos_settime() function.
;
;*******************************************************************************

	include version.inc
	.xlist
	include cmacros.inc
	include msdos.inc
	include errno.inc
	.list

dostime_t	struc
hour	db	?
minute	db	?
second	db	?
hsecond db	?
dostime_t	ends

sBegin	data
	externW errno
sEnd

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;unsigned _dos_settime(p_time) - return the current time
;
;Purpose:
;	The function "_dos_settime" allows the user to set the
;	time by hour (0-23), minute (0-59), second (0-59), and
;	hundredth of a second (0-99).
;	It uses INT 21h, Function 2Dh to set the time.
;
;Entry:
;	struct dostime_t {
;		unsigned char hour;
;		unsigned char minute;
;		unsigned char second;
;		unsigned char hsecond;
;	} *p_time;		address of structure to store time
;
;Exit:
;	The system time is changed and AX = 0 for success,
;	else AX = -1 and errno = EINVAL for an invalid time.
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

cProc	_dos_settime,<PUBLIC>,<>

	parmDP	_p_time 	; address of structure containing time

cBegin

if sizeD
	push	ds
	lds	bx,(_p_time)
else
	mov	bx,(_p_time)
endif
	mov	ch,[bx.hour]
	mov	cl,[bx.minute]
	mov	dh,[bx.second]
	mov	dl,[bx.hsecond]
if sizeD
	pop	ds
endif
	callos	settime 	; AL = 0 for success, -1 for error
	cmp	al,0FFH
	mov	ax,0		; MOV does not change flags
	jne	no_error
	mov	[errno],EINVAL
	dec	ax		; AX = -1
no_error:

ifdef	_WINDOWS
cEnd
else
	pop	bp
	ret
cEnd	<nogen>
endif


sEnd

	end
