/***
*cenvarg.c - setup up command line/environment blocks
*
*   Copyright (c) 1987-1992, Microsoft Corporation.    All rights reserved.
*
*Purpose:
*   defines _cenvarg() - set up command line/environment blocks
*
*******************************************************************************/

#include <register.h>
#include <errno.h>
#include <msdos.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include <internal.h>

#define ENV_MAX 32767

/***
*int _cenvarg(argv, envp, save, env, command,
*      argv0, batchname) - set up cmd lin/environ
*
*Purpose:
*   Sets up block form of the environment and the command line.
*   If "envp" is null, "environ" is used instead.
*   File handle info is passed in the environment if _fileinfo is !0.
*
*Entry:
*   char **argv - argument vector
*   char **envp - environment vector
*   char **save - point to char pointer (set to malloc'd space for environ)
*   char **env - pointer to char pointer (set to para aligned environ)
*   char *command - pointer to command line to be constructed
*   char *argv0 - NULL if from spawnve, command name if from execve
*   char *batchname - Points to script filename if in BATch mode.  Else NULL.
*
*Exit:
*   returns environment length if ok, -1 if fails
*   stores thru save, env, and stores into command
*   (allocates memory via malloc)
*
*Exceptions:
*
*******************************************************************************/

int
_cenvarg (argv, envp, save, env, command, argv0, batchname)
REG6 const char * const *argv;
REG7 const char * const *envp;
char **save;
char **env;
char *command;
const char *argv0;
const char *batchname;
{
    REG1 unsigned tmp = 0;
    REG2 char *p;
    char *ptmp;
    REG3 const char * const *vp;
    REG5 unsigned elength;
    int lngth;
    REG4 int osfilen;

    if (!envp)
    envp = _environ;

    if (envp) {
    for (vp = envp; *vp; tmp += strlen(*vp++) + 1 )
        if (tmp > ENV_MAX)
        break;
    }

    if (_fileinfo)
    for (osfilen = _nfile; osfilen && !_osfile[osfilen-1]; osfilen--)
        ;
    else
    osfilen = 0;    /* no _C_FILE_INFO */

    if (osfilen)    /* Add 1 (each) for the "=" & null byte */
       /* Plus 2 bytes for each value in _osfile */
    tmp += /* strlen(_acfinfo) */ CFI_LENGTH + 2 + osfilen + osfilen;

    if (argv0)
    tmp += strlen(argv0)+3;

    /**
     *** Add one for null terminator for entire environment
     *** The entire environment must be less than 32 KBytes
     **/
    if ((elength = ++tmp) > ENV_MAX) {
    errno = E2BIG;
    _doserrno = E_badenv;
    return(-1);
    }

    /* get memory for environment block.  need 15 extra bytes so that
     * the block can be paragraph aligned.
     *
     * Set _amblksiz down so that malloc won't be greedy with the OS.
     */

    tmp = _amblksiz;
    _amblksiz = 0x10;

    if (!(p = malloc(elength + 15))) {
    errno = ENOMEM;
    _doserrno = E_nomem;
    _amblksiz = tmp;
    return(-1);
    }

    _amblksiz = tmp;
    (*save) = ptmp = p;

    /* following has the effect of making p closest paragraph-aligned
     * address to ptmp such that p >= ptmp
     *
     * only operate on the offset part of the address
     */

    *((unsigned int *)&ptmp) = (*((unsigned int *)&ptmp)+0xf) & (~0xf);
    (*env) = p = ptmp;

    if (envp) {
    for (vp = envp; *vp; vp++)
        p = strchr(strcpy(p, *vp), '\0') + 1;
    }

    if (osfilen) {
    p = strchr(strcpy(p, _acfinfo), '\0');

    for(tmp = 0; osfilen--; ++tmp) {
        *p++ = (char)(((_osfile[tmp]>>4) & 0xF) + 'A');
        *p++ = (char)((_osfile[tmp] & 0xF) + 'A');
    }

    *p++ = '\0';
    }

    *p++ = '\0';        /* extra null to terminate environment strings */

    if (argv0) {
    *p++ = '\1';        /* DOS 3.X+ requires a count word before argv0 */
    *p++ = '\0';
    strcpy(p,argv0);    /* attach argv[0] if execve */
    }

    tmp = 0;
    p = command + 1;

    if (batchname) {
    p = strchr(strcpy(p, "/c "),'\0');
    p = strchr(strcpy(p, batchname),'\0');
    tmp = p - (command + 1);
    }

    if (argv[0]) {
    if (argv[1]) {
        *p++ = ' ';
        tmp++;
    }

    for (vp = &argv[1]; *vp; ) {
        lngth = strlen(*vp);
        if (tmp + lngth > 0x7d) { /* 7d = 0x80 - 3 (for count, CR, next space) */
        errno = E2BIG;
        _doserrno = E_badenv;
        free(*save);
        return(-1);
        }


        tmp += lngth;
        p = strchr( strcpy(p, *vp), '\0' );
        if ( *(++vp) )
        {
        *p++ = ' ';
        tmp++;
        }

    }
    }

    *p = '\r';
    *command = (char)tmp;
    return(elength);
}
