	page	,132
	title	dospawn - _dospawn (mode, name, cmdline, envblk)
;***
;dospawn.asm - spawn a child process
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _dospawn() - spawn a child process
;
;*******************************************************************************


.xlist
include version.inc
include cmacros.inc
include msdos.inc
include defsegs.inc
include errno.inc
.list

ifndef _WINDOWS
	_DEBUGSCREEN equ 1		; debug screen swapping
if sizeC
	_MOVE	     equ 1		; MOVE overlay manager support
endif
endif

ifdef _DEBUGSCREEN
CrtDefSegs  <dbdata>

sBegin	dbdata				;
	assumes ds,data 		; Used to do the running under
externW 	__aDBswpflg		; a debugger screen swapping
externW 	__aDBswpchk		;
sEnd	dbdata				;
	extrn	__aDBdoswp:ABS		;
endif	; _DEBUGSCREEN

ifdef _DOSEXT
newpopf macro
        local   a
	jmp	short $+3		; Fix for bug in POPF on IBM AT
a:	iret				; This simulates a POPF instruction
        push    cs
        call    a
endm
endif

ifdef	_DOSEXT
DXFUNC  = 44h
endif

sBegin	data

	assumes ds,data

spawn_block label byte
env	dw	0			; environment segment
command dd	0			; command line
_fcb5c	dw	dataoffset fcb5c,0
_fcb6c	dw	dataoffset fcb6c,0

fcb5c	db	10h dup (0)
fcb6c	db	10h dup (0)

externW _child
externW errno

ifdef	_MOVE
externB _ovlflag
endif

ifdef	_DOSEXT
externW	_fDosExt
endif

sEnd


P_WAIT	equ	0
P_NOWAIT equ	1


externNP _dosretax		; system call return point


ifdef	_MOVE			; MOVE Overlay manager
extern	__farstub:far
extern	__movepause(__farstub):far
extern	__moveresume(__farstub):far
endif

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;_dospawn(mode, name, cmdline, envblk) - spawn a child process
;
;Purpose:
;	spawns a child process
;
;Entry:
;	int mode -
;	char *name -
;	char *cmdline -
;	char *envblk -
;
;Exit:
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_dospawn,<PUBLIC>,<>

	parmw	smode
	parmdp	sname
	parmdp	scmdline
	parmdp	senvblk

userSP	dw	0
userSS	dw	0
save2_0 db	6 dup (0)	; must save & restore 4 bytes (& ds)
				; at ds:2eh in dos 2.0
ifdef	_DOSEXT
fDXActive   dw  0
endif

cBegin
	cmp	smode,P_NOWAIT	; check for valid mode flag
	jz	modeOK
	cmp	smode,P_WAIT
	jz	modeOK
	mov	[errno],EINVAL
	mov	ax,-1
	clc			; flag error
	jmp	_dosretax	; invalid mode flag, return error
modeOK:

	push	si
	push	di

if	sizeD			; ax = seg
	mov	ax,word ptr (senvblk)+2
else
	mov	ax,ds
endif

ifdef	_DOSEXT
        cmp     _fDosExt,0
        jnz     dosp20
endif
	mov	bx,word ptr (senvblk)
	mov	cl,4
	shr	bx,cl
	add	ax,bx		; seg += offset>>4
	mov	[env],ax

ifdef	_DOSEXT
; Fall through from above non-dos extender code and then jump around
; the dos extender code.
	jmp	short dosp25
;
; Dos requires that we pass a segment value for the environment for the child.
; Unfortunately, what we have is a far pointer, which has both a segment and
; an offset.  We need to convert the SEL:OFF pair into a linear address and
; then set up a temporary segment descriptor to point to that address.
dosp20: push    ax                  ;save the real environment segment address
        mov     cx,1                ;we need a temporary segment descriptor
        mov     ah,DXFUNC
        mov     al,4                ;allocate segment descriptors function
        int     2Fh
        mov     [env],ax            ;save as the environment segment

        pop     bx                  ;get back environment buffer segment address
        mov     ah,DXFUNC
        mov     al,0Ch              ;get segment address function
        int     2Fh
        mov     ax,word ptr (senvblk)   ;get buffer offset
        add     dx,ax               ;add to segment base address
        adc     cx,0
        mov     bx,[env]
        mov     ah,DXFUNC
        mov     al,0Bh              ;set segment address function
        int     2Fh
;
; We also need access to the flag that indicates if we are running under
; the Dos Extender, but unforunately there are places where we can't count
; on having a segment register to access our data segment.  We need to make
; a copy of the flag in the code segment.  To do this, we need a temporary
; segment alias to be able to write into the code segment.
        push    es
        mov     ah,DXFUNC
        mov     al,0Ah              ;make data alias function
        mov     bx,cs
        int     2Fh
        mov     es,ax
        mov     ax,_fDosExt
        mov     es:fDXActive,ax
        mov     bx,es
        xor     ax,ax
        mov     es,ax
        mov     cx,1
        mov     ah,DXFUNC
        mov     al,5                ;free selector function
        int     2Fh
        pop     es

dosp25:

endif	;_DOSEXT

; store command line pointer

	mov	ax,word ptr (scmdline)
	mov	word ptr [command],ax

if	sizeD
	mov	ax,word ptr (scmdline) + 2
	mov	word ptr [command+2],ax
else
	mov	word ptr [command+2],ds
endif

	mov	word ptr [_fcb5c+2],ds
	mov	word ptr [_fcb6c+2],ds

; set up args at 5c and 6c

	push	ds		; make sure es == ds
	pop	es

if	sizeD
	push	ds
	lds	si,dword ptr[command]
else
	mov	si,word ptr [command]
endif

	inc	si		; point at arg1 (or space before it)
	mov	di,dataOFFSET fcb5c
	mov	ax,DOS_fcbparse shl 8 + 1
	callos
	mov	ax,DOS_fcbparse shl 8 + 1
	mov	di,dataOFFSET fcb6c
	callos

if	sizeD
	pop	ds
endif

ifdef _MOVE
;
; Direct MOVE to give up it's resources around the spawn
;
	cmp	[_ovlflag],2	; MOVE overlay manager in use?
	jne	@F		; jump if not
	push	es
	call	__movepause
	pop	es
@@:
endif

ifdef _DEBUGSCREEN
;	Tell debugger to put user screen out
;
	cmp	__aDBswpflg,__aDBdoswp	; Aware debugger as parent?
	jne	@F			; No -- skip
	mov	bx,-1			; Force user screen to be shown.
	call	__aDBswpchk		; Yes -- see if we need to swap screens
@@:
endif	; _DEBUGSCREEN


;  we have a command line, default fcbs.  save the world and spawn!

	push	bp
	push	es
	push	ds

ifdef	_DOSEXT 		;not necessary under DOS >3.0 and
                                ; generates faults in protected mode
        cmp     fDXActive,0
        jnz     dosp30
endif

; DOS 2 trashes everything except CS in the exec call.
; DOS 3 and above is well-behaved, but some Novell networking sofware
; is not, so this routine should always do the save and restore.

; The following code assumes DS = DGROUP and CS = CODE

	mov	[userSS],ss
	mov	[userSP],sp

ifdef	_DOSEXT
dosp30:
        cmp     fDXActive,0
        jnz     dosp40
endif

	mov	di,2eh				;* for dos 2.0 bug
	mov	si,[di] 			;*
	mov	word ptr (save2_0),si		;*
	mov	si,[di+2]			;*
	mov	word ptr (save2_0)+2,si 	;*
	mov	word ptr (save2_0)+4,ds 	;*
dosp40:

	mov	bx,dataOFFSET spawn_block
	cmp	smode,P_WAIT
	jz	pwait

	mov	al,4		; P_NOWAIT for MULTI-TASKING MS-DOS ("4.0")
	xor	cx,cx		; mode is 0
	jmp	short doit

pwait:
	xor	al,al		; P_WAIT

doit:
	clc

; now we will set a flag to indicate that we are executing a child process
; in case the child doesn't set its own signal handling for ^C and a ^C is
; hit.	This will cause the parents signal handling routine (if any) to
; be invoked and it must use the DOS system default to handle the signal,
; not any signal handling specified by the parent.

	push	ax
	callos	kbdstatus	; clear any pending ^C's
	pop	ax
	mov	[_child],1	; flag that we're in a child process

if	sizeD
	lds	dx,sname
else
	mov	dx,sname
endif

	callos	exec

	assume	ss:nothing,ds:nothing,es:nothing

; Restore SS:SP.  Also restore data bytes trashed by DOS 2.0

	xchg	ax,bx		; bx = exec return value
	lahf			; save exec flag return

ifdef	_DOSEXT
        cmp     fDXActive,0
        jnz     dosp50
endif

	cli			; turn off interrupts
	mov	ss,[userSS]	; restore stack
	mov	sp,[userSP]
	sti			; turn interrupts back on

dosp50:
ifdef	_DOSEXT
        cmp     fDXActive,0
        jnz     dosp70
endif

ifndef SS_NEQ_DGROUP
	assume	ss:DGROUP
endif

; The following code assumes that CS = CODE

	mov	di,2eh				;* for dos 2.0 bug
	mov	ds,word ptr (save2_0)+4 	;*
	mov	si,word ptr (save2_0)+2 	;*
	mov	[di+2],si			;*
	mov	si,word ptr (save2_0)		;*
	mov	[di],si 			;*
dosp70:


;
; Restore DS=DGROUP
;
	pop	ds
	assume	ds:DGROUP

ifdef _MOVE
;
; Direct MOVE to restore itself.
;
	cmp	[_ovlflag],2	; MOVE overlay manager in use?
	jne	@F		; jump if not
	push	ax		; save spawn status
	push	bx		; and flags
	call	__moveresume
	pop	bx
	pop	ax
@@:
endif

;
; Restore flags and return value
;
	sahf			; restore exec return flags to flags
	xchg	ax,bx		; restore exec return value to ax

; reset the _child value back to 0 so the signal handler knows that
; we are back in the parent process.

	mov	[_child],0

	pop	es
	pop	bp
	pop	di
	pop	si
	jc	errret		; ax = error code

	callos	wait		; get process return code

errret:

ifdef	_DOSEXT
	pushf			;[1]save the CY flag again
        cmp     fDXActive,0
        jz      dosp80
;
; We need to free the temporary segment descriptor that we allocated
; for passing the environment to the child.
	push	ax
        mov     bx,[env]
        mov     cx,1
        mov     ah,DXFUNC
        mov     al,5
	int	2Fh
	pop	ax
dosp80:
	newpopf			;[1]restore the CY flag again
endif

	jmp	_dosretax

cEnd	nogen


sEnd

	end
