	page	,132
	title	execload	-- C exec loader
;***
;execload.asm - exec loader
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _execload() - call the exec loader
;
;*******************************************************************************

?DF	=	1		; tell cmacros.inc we want to define our own segments

include version.inc
.xlist
include cmacros.inc
include defsegs.inc
include errno.inc
.list

CrtDefSegs  <code,data>
CrtDefSegs  <eseg>

sBegin	eseg
if	sizeC
exadr	dd	1 dup (?)	; leave hole for real exec
else
exadr	dw	1 dup (?)
endif
sEnd

externNP _dosretax
externW errno

sBegin	code
assumes cs,code
assumes ds,data

page
;***
;_execload() - call the execloader
;
;Purpose:
;	Calls the exec loader
;
;Entry:
;
;Exit:
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_execload,<PUBLIC>,<>

cBegin	nogen
if	sizeC
	mov	cx,word ptr [exadr+2] ; test segment for 0
	jcxz	notloaded
	jmp	[exadr]
else
	mov	cx,word ptr [exadr] ; test offset for 0
	jcxz	notloaded
	jmp	cx
endif

notloaded:
	mov	ax,-1
	mov	[errno],EINVAL
	jmp	_dosretax

cEnd	nogen

sEnd
	end
