/***
*execve.c - execute a file with given environ
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines execve() - execute a file with given environment
*
*******************************************************************************/

#include <register.h>
#include <fcntl.h>
#include <assert.h>
#include <errno.h>
#include <msdos.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <share.h>
#include <process.h>
#include <internal.h>
#include <mbstring.h>

#pragma check_stack+        /* turn on stack checking */

#define SLASHCHAR   '\\'
#define XSLASHCHAR  '/'


/***
*static int comexebat(mode, name, argv, envp, notbatchmode)- do the spawn after
*   name fixup
*
*Purpose:
*   Spawns a child process with given parameters and environment.  Either
*   overlays current process or loads in free memory while parent process
*   waits.  If the named file is a .bat file, modifies the calling sequence
*   and prepends the /c and filename arguments into the command string
*
*Entry:
*   int mode - mode to spawn (WAIT, NOWAIT, or OVERLAY), only WAIT and
*       OVERLAY currently supported
*   char *name - pathname of file to spawn.  Includes the extension
*   char **argv - vector of parameter strings
*   char **envp - vector of environment variables
*   int notbatchmode - equal to zero when processing a .BAT file
*
*Exit:
*   returns exit code of child process
*   if fails, returns -1
*
*Exceptions:
*
*******************************************************************************/

#define COM_STR_SIZE  0x80

static int comexebat (const char *, const char * const *,
            const char * const *, int);

static int
comexebat (name, argv, envp, notbatchmode)
REG2 const char *name;
const char * const *argv;
const char * const *envp;
int notbatchmode;  /* do special processing if zero*/

{
    char *envblock;
    unsigned int xh[15];
    char command[COM_STR_SIZE];
    char *save;
    unsigned long filesize;
    REG7 int elength;
    REG6 int flag = 1;  /* 0 = .exe, 1 = .com */
    REG5 int fd;
    const char *batname;

    save = NULL;

    if (!notbatchmode) {

    batname = name; /* cause the "/c filename" to be pre-pended */

    if (!(name = getenv("COMSPEC"))) {
        errno = ENOEXEC;
        return -1;
    }

    if ((elength = _cenvarg(argv, envp, &save, &envblock, command, name, batname)) == -1)
        return -1;

    }


    if ((fd = _sopen(name, _O_RDONLY|_O_BINARY, _SH_DENYWR)) == -1) {
    if (save)
        free(save);
    return -1;  /* check to see if file exists */
    }

    if (_read(fd, (char *) xh, 0x18) == -1) {
    _close(fd);
    if (save)
        free(save);
    errno = ENOEXEC;
    _doserrno = E_badfmt;
    return(-1);
    }
    filesize = (_lseek(fd, 0L, 2)+15) >> 4;
    _close(fd);

    if (xh[0] == 0x4d5a || xh[0] == 0x5a4d)
    flag--;

    if (notbatchmode)
    if ((elength = _cenvarg(argv, envp, &save, &envblock, command, name, NULL)) == -1)
        return -1;

    _doexec(flag, name, strlen(name) + 1, command, envblock, elength,
    (xh[2] << 5) + xh[5] - xh[4], xh[7], xh[8], xh[11], xh[10],
    (unsigned int)filesize);

    free(save);
    return -1; /* if doexec returns, it has failed */
}


/***
*int _execve(name, argv, envp) - execute file with given environment
*
*Purpose:
*   Execute the given file with the given arguments and environment.
*   Determines the load module size and passes it to _doexec.  If any
*   problem doing this or _doexec returns, return -1.
*
*Entry:
*   char *name - file to execute
*   char **argv - argument vector
*   char **envp - environment vector
*
*Exit:
*   destroys the calling process (hopefully)
*   if fails, returns -1
*
*Exceptions:
*
*******************************************************************************/

static char near *exstrings[] = { ".bat", ".exe", ".com" };
    /* we try them in reverse order-- .com, .exe, .bat */

int
_execve (name, argv, envp)
REG2 const char *name;
const char * const *argv;
const char * const *envp;
{
    REG1 char *p;
    REG3 char *q;
    REG4 int rc;
    REG5 int i;
    char *ext;      /* where the extension goes if we have to add one */

    assert(name != NULL);
    assert(*name != '\0');
    assert(argv != NULL);
    assert(*argv != NULL);
    assert(**argv != '\0');

    /* In a SBCS build, _mbsrchr maps to strrchr.   */

    p = _mbsrchr(name, SLASHCHAR);
    q = strrchr(name, XSLASHCHAR);

    if (!q) {
    if (!p)
        p = (char *)name;   /* p == q == NULL */
    }
    else if (!p || q > p)   /* p == NULL or q > p */
    p = q;

    rc = -1;            /* init to error value */

    if (ext = strchr(p, '.'))  {
    /* extension given; only do filename */
    if (_access(name, 0) != -1)
        /* we compare the extension against .BAT and send comexebat()
           a zero if we are working on a .BAT file */
        rc = comexebat(name, argv, envp, _stricmp(ext, exstrings[0]));
    }
    else    {
    /* no extension; try .bat, then .com and .exe */
    if (!(p = malloc(strlen(name) + 5)))
        return(-1);

    strcpy(p, name);
    ext = p + strlen(name);

    for (i = 2; i >= 0; --i) {
        strcpy(ext, exstrings[i]);
        if (-1 != _access(p, 0)) {
             /* when i == 0, we know we have a .BAT file.  comexebat()
            needs this information */
        rc = comexebat(p, argv, envp, i);
        break;
        }
    }
    free(p);
    }

    return rc;
}
