/***
*execl.c - execute a file with a list of arguments
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines execl() - execute a file with a list of arguments
*
*******************************************************************************/

#include <assert.h>
#include <stdlib.h>
#include <process.h>

/***
*int _execl(filename, arglist) - execute a file with arg list
*
*Purpose:
*   Transform the argument list so it is a vector, then pass its address
*   to execve.  Use a pointer to the default environment vector.
*
*Entry:
*   char *filename - file to execute
*   char *arglist  - list of arguments
*   call as execl(path, arg0, arg1, ..., argn, NULL);
*
*Exit:
*   destroys the calling process, hopefully
*   returns -1 if fails
*
*Exceptions:
*
*******************************************************************************/

int  _execl (const char * filename, const char * arglist, ...)
{
    assert(filename != NULL);
    assert(*filename != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');

    return(_execve(filename,&arglist,_environ));
}
