/***
*execle.c - execute a file with arg list and environment
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines execle() - execute a file
*
*******************************************************************************/

#include <register.h>
#include <assert.h>
#include <stddef.h>
#include <process.h>

/***
*int _execle(filename, arglist) - execute a file
*
*Purpose:
*   Execute the given file (overlays the calling process).
*   We must dig the environment vector out of the stack and pass it
*   and address of argument vector to execve.
*
*Entry:
*   char *filename - file to execute
*   char *arglist  - argument list followed by environment
*   should be called like execle(path, arg0, arg1, ..., argn, NULL, envp);
*
*Exit:
*   destroys calling process (hopefully)
*   if fails, returns -1.
*
*Exceptions:
*
*******************************************************************************/

int  _execle (const char * filename, const char * arglist, ...)
{
    REG1 const char **e_search = &arglist;

    assert(filename != NULL);
    assert(*filename != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');

    while (*e_search++)
        ;

    return(_execve(filename,&arglist,(char **)*e_search));
}
