/***
*execlp.c - execute a file (search along PATH)
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines execlp() - execute a file and search along PATH
*
*******************************************************************************/

#include <assert.h>
#include <stddef.h>
#include <process.h>

/***
*int _execlp(filename, arglist) - execute a file, search along PATH
*
*Purpose:
*   Execute the given file with the given arguments; search along PATH
*   for the file. We pass the arguments to execvp where several paths
*   will be tried until one works.
*
*Entry:
*   char *filename - file to execute
*   char *arglist  - argument list
*   call as execlp(path, arg0, arg1, ..., argn, NULL);
*
*Exit:
*   destroys calling process (hopefully)
*   returns -1 if fails.
*
*Exceptions:
*
*******************************************************************************/

int  _execlp (const char * filename, const char * arglist, ...)
{
    assert(filename != NULL);
    assert(*filename != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');

    return(_execvp(filename,&arglist));
}
