/***
*execlpe.c - execute a file with environ, search along path
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines execlpe() - execute a file with environ and search along PATH
*
*******************************************************************************/

#include <register.h>
#include <assert.h>
#include <stdlib.h>
#include <process.h>

/***
*int _execlpe(filename, arglist) - execute a file with environ
*
*Purpose:
*   Executes the given file with the parameters and the environment
*   which is passed after the parameters.  Searches along the PATH
*   for the file (done by execvp).
*
*Entry:
*   char *filename - file to execute
*   char *arglist  - argument list (environment is at the end)
*   call as execlpe(path, arg0, arg1, ..., argn, NULL, envp);
*
*Exit:
*   destroys the calling process (hopefully)
*   if fails, returns -1
*
*Exceptions:
*
*******************************************************************************/

int  _execlpe (const char * filename, const char * arglist, ...)
{
    REG1 const char **argp;

    assert(filename != NULL);
    assert(*filename != '\0');
    assert(arglist != NULL);
    assert(*arglist != '\0');

    argp = &arglist;
    while (*argp++)
        ;

    return(_execvpe(filename,&arglist,(char **)*argp));
}
