/***
*execv.c - execute a file
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines execv() - execute a file
*
*******************************************************************************/

#include <assert.h>
#include <stdlib.h>
#include <process.h>

/***
*int _execv(filename, argvector) - execute a file
*
*Purpose:
*   Executes a file with given arguments.  Passes arguments to execve and
*   uses pointer to the default environment.
*
*Entry:
*   char *filename   - file to execute
*   char **argvector - vector of arguments.
*
*Exit:
*   destroys calling process (hopefully)
*   if fails, returns -1
*
*Exceptions:
*
*******************************************************************************/

int  _execv (filename, argvector)
const char *filename;
const char * const *argvector;
{
    assert(filename != NULL);
    assert(*filename != '\0');
    assert(argvector != NULL);
    assert(*argvector != NULL);
    assert(**argvector != '\0');

    return(_execve(filename,argvector,_environ));
}
