/***
*getproc.c - Get the address of a procedure in a DLL.
*
*   Copyright (c) 1991, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines _getdllprocadd() - gets a procedure address by name or
*   ordinal
*
*******************************************************************************/

#ifdef WIN
#include <windows.h>
#else
#error Unknown target
#endif
#include <stdlib.h>
#include <process.h>

/***
*int (*)() _getdllprocaddr(handle, name, ordinal) - Get the address of a
*   DLL procedure specified by name or ordinal
*
*Purpose:
*
*Entry:
*   int handle - a DLL handle from _loaddll
*   char * name - Name of the procedure, or NULL to get by ordinal
*   int ordinal - Ordinal of the procedure, or -1 to get by name
*
*
*Exit:
*   returns a pointer to the procedure if found
*   returns NULL and sets _doserrno if not found
*
*Exceptions:
*
*******************************************************************************/

int (__far  *  _getdllprocaddr(int hMod,
                     const char * szProcName,
                     int iOrdinal))()
{
    typedef int (__far  * PFUNC)();
#ifdef WIN
    PFUNC pfn;

    if (szProcName == NULL) {
    if (iOrdinal <= 65535) {
        pfn = (PFUNC)GetProcAddress((HANDLE)hMod, (LPSTR)iOrdinal);
    }
    }
    else {
    if (iOrdinal == -1) {
        pfn = (PFUNC)GetProcAddress((HANDLE)hMod, (LPSTR)szProcName);
    }
    }
    if (pfn == NULL) {
    _doserrno = 127;    // Procedure not found
    }
    return (pfn);

#else
#endif

}
