/***
*loaddll.c - load or free a Dynamic Link Library
*
*   Copyright (c) 1992, Microsoft Corporation. All rights reserved.
*
*Purpose:
*   defines _loaddll() and _unloaddll() - load and unload DLL
*
*******************************************************************************/

#ifdef WIN
#include <windows.h>
#else
#error Unknown target
#endif
#include <stdlib.h>
#include <process.h>


/***
*int _loaddll(filename) - Load a dll
*
*Purpose:
*   Load a DLL into memory
*
*Entry:
*   char *filename - file to load
*
*Exit:
*   returns a unique DLL (module) handle if succeeds
*   returns 0 if fails
*
*Exceptions:
*
*******************************************************************************/

int  _loaddll(const char * szName)
{
#ifdef WIN
    int ret;

    ret = (int)LoadLibrary((LPSTR)szName);
    if (ret < 32) {
    switch (ret) {
    case 0:
        _doserrno = 8;  // Not enough memory
        break;
    case 2:         // File not found
    case 3:         // Path not found
        _doserrno = ret;    // return more or less matches error number

    case 5:         // Attempt to dynamically link to a task
    case 6:         // Requires separate data seg for each task
    case 10:        // Incorrect Windows version
    case 11:        // Invalid .EXE (non Windows)
    case 12:        // OS/2 file
    case 13:        // DOS 4.0 app
    case 14:        // Unknownn .EXE type
    case 15:        // Loading .EXE for earlier Windows
    case 16:        // Loading second instance with multiple data
    case 17:        // Loading in EMS mode nonshareable DLLs
    case 18:        // Loading protect mode only from real mode
    default:
        _doserrno = 11; // Format invalid for various reasons
    }
    return (-1);
    }
    return (ret);
#else
#endif
}

/***
*int _unloaddll(handle) - Unload a dll
*
*Purpose:
*   Unloads a DLL. The resources of the DLL will be freed if no other
*   processes are using it.
*
*Entry:
*   int handle - handle from _loaddll
*
*Exit:
*   returns 0 if succeeds
*   returns DOS error if fails
*
*Exceptions:
*
*******************************************************************************/

int  _unloaddll(int hMod)
{
#ifdef WIN
    FreeLibrary((HANDLE)hMod);
    return (0);
#else
#endif
}
